#include ".\level.h"
#include ".\LD10.h"



Level::Level(void)
{

  Clear();

}

Level::~Level(void)
{
}



void Level::Render()
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );

  for ( int i = 0; i < 32; ++i )
  {
    for ( int j = 0; j < 22; ++j )
    {
      if ( ( m_Field[i][j] == LD10::TILE_GOAL )
      ||   ( m_Field[i][j] == LD10::TILE_NO_BOMB_AREA ) )
      {
        theApp.RenderTextureSection( i * 20, j * 20, theApp.m_Tiles[m_Field[i][j]] );
      }
    }
  }

  // Render Shadows
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  tListObjects::iterator    it( m_Objects.begin() );
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it );

    Obj.RenderShadow();

    ++it;
  }

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );

  for ( int i = 0; i < 32; ++i )
  {
    for ( int j = 0; j < 22; ++j )
    {
      if ( ( m_Field[i][j] != LD10::TILE_EMPTY )
      &&   ( m_Field[i][j] != LD10::TILE_NO_BOMB_AREA )
      &&   ( m_Field[i][j] != LD10::TILE_GOAL ) )
      {
        theApp.RenderTextureSection( i * 20, j * 20, theApp.m_Tiles[m_Field[i][j]] );
      }
    }
  }

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  // Render Objects
  it = m_Objects.begin();
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it );

    Obj.Render();

    ++it;
  }

  // Render FX
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  // Render Objects
  it = m_Objects.begin();
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it );

    Obj.RenderFX();

    ++it;
  }

}



void Level::Update( float ElapsedTime )
{

  m_PhysicsStep += ElapsedTime;

  while ( m_PhysicsStep >= 0.02f )
  {
    tListObjects::iterator    it( m_Objects.begin() );
    while ( it != m_Objects.end() )
    {
      GameObject& Obj( *it );

      Obj.UpdatePhysicsStep( *this );
      if ( Obj.m_RemoveMe )
      {
        it = m_Objects.erase( it );
      }
      else
      {
        ++it;
      }
    }

    m_PhysicsStep -= 0.02f;
  }

  tListObjects::iterator    it( m_Objects.begin() );
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it );

    Obj.Update( ElapsedTime, *this );
    if ( Obj.m_RemoveMe )
    {
      it = m_Objects.erase( it );
    }
    else
    {
      ++it;
    }
  }

  it = m_Objects.begin();
  while ( it != m_Objects.end() )
  {
    GameObject&   Obj( *it );

    if ( Obj.m_Type == LD10::GO_EXPLOSION_RING )
    {
      tListObjects::iterator    it2( m_Objects.begin() );
      while ( it2 != m_Objects.end() )
      {
        GameObject& Obj2( *it2 );

        if ( &Obj2 != &Obj )
        {
          if ( Obj2.m_Type == LD10::GO_STEEL_DIAMOND )
          {
            int Width = (int)( Obj.m_LifeTime * 100.0f );
            if ( ( Obj.m_DispX - Obj2.m_DispX ) * ( Obj.m_DispX - Obj2.m_DispX ) + ( Obj.m_DispY - Obj2.m_DispY ) * ( Obj.m_DispY - Obj2.m_DispY ) < Width * Width )
            {
              bool    CanOpen = true;

              if ( Obj2.m_Number )
              {
                if ( Obj2.m_PushedByThese.find( Obj.m_ObjIndex ) != Obj2.m_PushedByThese.end() )
                {
                  CanOpen = false;
                }
                else if ( m_CurBombNumber != Obj2.m_Number - 1 )
                {
                  CanOpen = false;
                  theApp.PlaySound( LD10::SOUND_BAD );
                  Obj2.m_PushedByThese.insert( Obj.m_ObjIndex );
                }
                else
                {
                  m_CurBombNumber = Obj2.m_Number;
                }
              }
              if ( CanOpen )
              {
                Obj2.m_Type = LD10::GO_DIAMOND;
                Obj2.m_Texture = LD10::TEX_DIAMOND;

                theApp.PlaySound( LD10::SOUND_OPEN_DIAMOND );
              }
            }
          }
          else if ( Obj2.m_Type == LD10::GO_BOMB )
          {
            int Width = (int)( Obj.m_LifeTime * 100.0f );
            if ( ( Obj.m_DispX - Obj2.m_DispX ) * ( Obj.m_DispX - Obj2.m_DispX ) + ( Obj.m_DispY - Obj2.m_DispY ) * ( Obj.m_DispY - Obj2.m_DispY ) < Width * Width )
            {
              Obj2.m_Type = LD10::GO_BURNING_BOMB;
              Obj2.m_Texture = LD10::TEX_BURNING_BOMB;
              Obj2.m_LifeTime = 0.4f;
            }
          }
          else if ( ( Obj2.m_Type == LD10::GO_TARGET_BALL )
          ||        ( Obj2.m_Type == LD10::GO_ROLLING_UNIT ) )
          {
            int Width = (int)( Obj.m_LifeTime * 100.0f );
            if ( ( Obj.m_DispX - Obj2.m_DispX ) * ( Obj.m_DispX - Obj2.m_DispX ) + ( Obj.m_DispY - Obj2.m_DispY ) * ( Obj.m_DispY - Obj2.m_DispY ) < Width * Width )
            {
              if ( Obj2.m_PushedByThese.find( Obj.m_ObjIndex ) == Obj2.m_PushedByThese.end() )
              {
                // not yet pushed by this one
                float   Length = sqrtf( (float)( Obj2.m_DispX - Obj.m_DispX ) * ( Obj2.m_DispX - Obj.m_DispX ) + ( Obj2.m_DispY - Obj.m_DispY ) * ( Obj2.m_DispY - Obj.m_DispY ) );
                if ( Length != 0.0f )
                {
                  float   DX = (float)( Obj2.m_DispX - Obj.m_DispX );
                  float   DY = (float)( Obj2.m_DispY - Obj.m_DispY );

                  // normalize
                  DX /= Length;
                  DY /= Length;

                  if ( Length < 150.0f )
                  {
                    float   Power = 300.0f * ( 150.0f - Length ) / ( 150.0f / 8.0f );

                    Obj2.m_AccX += Power * DX; 
                    Obj2.m_AccY += Power * DY; 

                    Obj2.m_PushedByThese.insert( Obj.m_ObjIndex );
                  }
                }
              }
            }
          }
        }
        ++it2;
      }

    }
    else if ( ( Obj.m_Type == LD10::GO_TARGET_BALL )
    ||        ( Obj.m_Type == LD10::GO_ROLLING_UNIT ) )
    {
      tListObjects::iterator    it2( m_Objects.begin() );
      while ( it2 != m_Objects.end() )
      {
        GameObject& Obj2( *it2 );

        if ( &Obj2 != &Obj )
        {
          if ( Obj2.m_Type == LD10::GO_TRIGGER_BOMB )
          {
            if ( ( Obj.m_DispX - Obj2.m_DispX ) * ( Obj.m_DispX - Obj2.m_DispX ) + ( Obj.m_DispY - Obj2.m_DispY ) * ( Obj.m_DispY - Obj2.m_DispY ) < 28 * 28 )
            {
              // bounce back
              Obj.m_SpeedX = -Obj.m_SpeedX;
              Obj.m_SpeedY = -Obj.m_SpeedY;
              Obj.m_AccX = -Obj.m_AccX;
              Obj.m_AccY = -Obj.m_AccY;

              // Trigger bomb explodes
              Obj2.m_Type = LD10::GO_EXPLOSION;
              Obj2.m_LifeTime = 0.0f;
              Obj2.m_Texture = LD10::TEX_EXPLOSION_1;

              GameObject*    pExplosionRing = CreateObject( LD10::GO_EXPLOSION_RING );

              pExplosionRing->m_DispX = Obj2.m_DispX;
              pExplosionRing->m_DispY = Obj2.m_DispY;

              theApp.PlaySound( LD10::SOUND_EXPLOSION2 );
            }
          }
        }
        ++it2;
      }

    }

    ++it;
  }

  if ( !m_Solved )
  {
    if ( IsSolved() )
    {
      m_Solved = true;
    }
  }

}



void Level::Clear()
{

  m_Solved = false;
  m_PhysicsStep = 0.0f;
  m_Objects.clear();
  for ( int i = 0; i < 32; ++i )
  {
    for ( int j = 0; j < 22; ++j )
    {
      m_Field[i][j] = LD10::TILE_EMPTY;
    }
  }
  for ( int i = 0; i < 32; ++i )
  {
    m_Field[i][0] = LD10::TILE_WALL;
    m_Field[i][21] = LD10::TILE_WALL;
  }
  for ( int i = 0; i < 22; ++i )
  {
    m_Field[0][i] = LD10::TILE_WALL;
    m_Field[31][i] = LD10::TILE_WALL;
  }
  m_BombsAvailable = 0;
  m_Name.erase();
  m_CurBombNumber = 0;
  m_ObjIndex = 1;

}



bool Level::Load( int Nr )
{

  Clear();

  char    Temp[260];

  wsprintf( Temp, "data\\level%d.dat", Nr );

  FILE*   In = fopen( Temp, "rb" );
  if ( In == NULL )
  {
    return false;
  }

  fread( &m_Field, sizeof( m_Field ), 1, In );

  int   Count = 0;
  fread( &Count, sizeof( Count ), 1, In );
  for ( int i = 0; i < Count; ++i )
  {
    LD10::GameObjectType    ObjType;

    fread( &ObjType, sizeof( ObjType ), 1, In );

    GameObject*    pObjNew = CreateObject( ObjType );

    fread( &pObjNew->m_DispX, sizeof( pObjNew->m_DispX ), 1, In );
    fread( &pObjNew->m_DispY, sizeof( pObjNew->m_DispY ), 1, In );
    fread( &pObjNew->m_LifeTime, sizeof( pObjNew->m_LifeTime ), 1, In );
    fread( &pObjNew->m_Number, sizeof( pObjNew->m_Number ), 1, In );

    if ( pObjNew->m_Type == LD10::GO_TIMEBOMB )
    {
      pObjNew->m_Texture = (LD10::TextureTypes)( LD10::TEX_TIMEBOMB_8 + (int)( pObjNew->m_LifeTime / ( 5.0f / 9.0f ) ) );
    }
  }
  fread( &m_BombsAvailable, sizeof( m_BombsAvailable ), 1, In );
  int   Size = 0;
  fread( &Size, sizeof( Size ), 1, In );
  if ( Size )
  {
    char*    pBuffer = new char[Size];
    fread( pBuffer, Size, 1, In );
    m_Name.append( pBuffer, Size );
    delete[] pBuffer;
  }
  fclose( In );

  return true;

}



bool Level::Save( int Nr )
{

  char    Temp[260];

  wsprintf( Temp, "data\\level%d.dat", Nr );

  FILE*   Out = fopen( Temp, "wb" );
  if ( Out == NULL )
  {
    return false;
  }

  fwrite( &m_Field, sizeof( m_Field ), 1, Out );

  int   Count = (int)m_Objects.size();
  fwrite( &Count, sizeof( Count ), 1, Out );

  tListObjects::iterator    itObj( m_Objects.begin() );
  while ( itObj != m_Objects.end() )
  {
    GameObject& Obj( *itObj );

    fwrite( &Obj.m_Type, sizeof( Obj.m_Type ), 1, Out );

    fwrite( &Obj.m_DispX, sizeof( Obj.m_DispX ), 1, Out );
    fwrite( &Obj.m_DispY, sizeof( Obj.m_DispY ), 1, Out );
    fwrite( &Obj.m_LifeTime, sizeof( Obj.m_LifeTime ), 1, Out );
    fwrite( &Obj.m_Number, sizeof( Obj.m_Number ), 1, Out );

    ++itObj;
  }

  fwrite( &m_BombsAvailable, sizeof( m_BombsAvailable ), 1, Out );
  int   Size = (int)m_Name.length();
  fwrite( &Size, sizeof( Size ), 1, Out );
  fwrite( m_Name.c_str(), Size, 1, Out );
  fclose( Out );

  return true;

}



GameObject* Level::CreateObject( LD10::GameObjectType ObjType )
{

  GameObject    Obj;

  Obj.m_Type = ObjType;

  switch ( Obj.m_Type )
  {
    case LD10::GO_BOMB:
      Obj.m_Texture = LD10::TEX_BOMB;
      break;
    case LD10::GO_TRIGGER_BOMB:
      Obj.m_Texture = LD10::TEX_TRIGGER_BOMB;
      break;
    case LD10::GO_BURNING_BOMB:
      Obj.m_Texture = LD10::TEX_BURNING_BOMB;
      break;
    case LD10::GO_DIAMOND:
      Obj.m_Texture = LD10::TEX_DIAMOND;
      break;
    case LD10::GO_EXPLOSION:
      Obj.m_Texture = LD10::TEX_EXPLOSION_1;
      break;
    case LD10::GO_EXPLOSION_RING:
      Obj.m_Texture = LD10::TEX_EXPLOSION_RING;
      break;
    case LD10::GO_STEEL_DIAMOND:
      Obj.m_Texture = LD10::TEX_STEEL_DIAMOND;
      break;
    case LD10::GO_TIMEBOMB:
      Obj.m_Texture = LD10::TEX_TIMEBOMB_8;
      break;
    case LD10::GO_TARGET_BALL:
      Obj.m_Texture = LD10::TEX_TARGET_UNIT;
      break;
    case LD10::GO_ROLLING_UNIT:
      Obj.m_Texture = LD10::TEX_ROLLING_UNIT;
      break;
  }

  Obj.m_ObjIndex = m_ObjIndex;
  ++m_ObjIndex;

  m_Objects.push_back( Obj );

  return &m_Objects.back();

}



void Level::RemoveObject( GameObject* pObj )
{

  tListObjects::iterator    itObj( m_Objects.begin() );
  while ( itObj != m_Objects.end() )
  {
    GameObject& Obj( *itObj );

    if ( &Obj == pObj )
    {
      m_Objects.erase( itObj );
      return;
    }

    ++itObj;
  }

}



bool Level::IsBlocked( GameObject* pObj, int X, int Y, int W, int H )
{

  X -= W / 2;
  Y -= H / 2;

  int     X1 = X / 20;
  int     X2 = ( X + W - 1 ) / 20;
  int     Y1 = Y / 20;
  int     Y2 = ( Y + H - 1 ) / 20;

  bool    Blocked = false;

  for ( int x = X1; x <= X2; ++x )
  {
    for ( int y = Y1; y <= Y2; ++y )
    {
      if ( ( x < 0 )
      ||   ( x >= 32 )
      ||   ( y < 0 )
      ||   ( y >= 22 ) )
      {
        Blocked = true;
      }
      else
      {
        LD10::TileTypes Tile = (LD10::TileTypes)m_Field[x][y];

        if ( ( Tile != LD10::TILE_EMPTY )
        &&   ( Tile != LD10::TILE_NO_BOMB_AREA )
        &&   ( Tile != LD10::TILE_GOAL ) )
        {
          Blocked = true;
        }
      }
    }
  }

  return Blocked;

}



bool Level::IsAreaGoal( int X, int Y, int W, int H )
{

  X -= W / 2;
  Y -= H / 2;

  int     X1 = X / 20;
  int     X2 = ( X + W - 1 ) / 20;
  int     Y1 = Y / 20;
  int     Y2 = ( Y + H - 1 ) / 20;

  for ( int x = X1; x <= X2; ++x )
  {
    for ( int y = Y1; y <= Y2; ++y )
    {
      if ( ( x < 0 )
      ||   ( x >= 32 )
      ||   ( y < 0 )
      ||   ( y >= 22 ) )
      {
        return false;
      }
      else
      {
        LD10::TileTypes Tile = (LD10::TileTypes)m_Field[x][y];

        if ( Tile != LD10::TILE_GOAL )
        {
          return false;
        }
      }
    }
  }

  return true;

}



bool Level::CanAreaContainBomb( int X, int Y, int W, int H )
{

  X -= W / 2;
  Y -= H / 2;

  int     X1 = X / 20;
  int     X2 = ( X + W - 1 ) / 20;
  int     Y1 = Y / 20;
  int     Y2 = ( Y + H - 1 ) / 20;

  for ( int x = X1; x <= X2; ++x )
  {
    for ( int y = Y1; y <= Y2; ++y )
    {
      if ( ( x < 0 )
      ||   ( x >= 32 )
      ||   ( y < 0 )
      ||   ( y >= 22 ) )
      {
        return false;
      }
      else
      {
        LD10::TileTypes Tile = (LD10::TileTypes)m_Field[x][y];

        if ( Tile != LD10::TILE_EMPTY )
        {
          return false;
        }
      }
    }
  }

  return true;

}



bool Level::MoveObject( GameObject* pObj, float DX, float DY )
{

  pObj->m_FractX += DX;
  pObj->m_FractY += DY;

  bool Blocked = false;

  while ( ( pObj->m_FractX >= 1.0f )
  ||      ( pObj->m_FractX <= -1.0f )
  ||      ( pObj->m_FractY <= -1.0f )
  ||      ( pObj->m_FractY >= 1.0f ) )
  {
    if ( pObj->m_FractX <= -1.0f )
    {
      // go left
      if ( IsBlocked( pObj, (int)pObj->m_DispX - 1, pObj->m_DispY, 25, 25 ) )
      {
        // blocked left
        pObj->m_FractX = 0.0f;
        pObj->m_SpeedX = -pObj->m_SpeedX;
        Blocked = true;
      }
      else
      {
        pObj->m_DispX--;
        pObj->m_FractX += 1.0f;
      }
    }
    else if ( pObj->m_FractX >= 1.0f )
    {
      // go right
      if ( IsBlocked( pObj, (int)pObj->m_DispX + 1, pObj->m_DispY, 25, 25 ) )
      {
        // blocked right
        pObj->m_FractX = 0.0f;
        pObj->m_SpeedX = -pObj->m_SpeedX;
        Blocked = true;
      }
      else
      {
        pObj->m_DispX++;
        pObj->m_FractX -= 1.0f;
      }
    }
    if ( pObj->m_FractY <= -1.0f )
    {
      // go up
      if ( IsBlocked( pObj, pObj->m_DispX, pObj->m_DispY - 1, 25, 25 ) )
      {
        // blocked up
        pObj->m_FractY = 0.0f;
        pObj->m_SpeedY = -pObj->m_SpeedY;
        Blocked = true;
      }
      else
      {
        pObj->m_DispY--;
        pObj->m_FractY += 1.0f;
      }
    }
    else if ( pObj->m_FractY >= 1.0f )
    {
      // go down
      if ( IsBlocked( pObj, pObj->m_DispX, pObj->m_DispY + 1, 25, 25 ) )
      {
        // blocked down
        pObj->m_FractY = 0.0f;
        pObj->m_SpeedY = -pObj->m_SpeedY;
        Blocked = true;
      }
      else
      {
        pObj->m_DispY++;
        pObj->m_FractY -= 1.0f;
      }
    }
  }
  return !Blocked;

}



bool Level::IsSolved()
{

  if ( m_Solved )
  {
    return true;
  }

  tListObjects::iterator    it( m_Objects.begin() );
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it );

    if ( Obj.m_Type == LD10::GO_TARGET_BALL )
    {
      if ( !IsAreaGoal( Obj.m_DispX, Obj.m_DispY, 25, 25 ) )
      {
        return false;
      }
    }
    else if ( Obj.m_Type == LD10::GO_STEEL_DIAMOND )
    {
      return false;
    }

    ++it;
  }

  theApp.PlaySound( LD10::SOUND_LEVEL_DONE );
  return true;

}